/*:
 * @target MZ
 * @plugindesc メッセージウィンドウの行数を変数で制御します。
 * @author @@
 *
 * @param VariableId
 * @text 行数設定用変数ID
 * @desc ウィンドウの表示行数として使用するゲーム変数のIDを指定します。
 * @default 1
 * @type variable
 *
 * @help
 * このプラグインは、メッセージウィンドウの表示行数を、
 * プラグインパラメータで指定したゲーム変数の値に変更します。
 * * 変数の値が1以上のときに有効となります。
 * * 使用方法:
 * 1. プラグイン管理で「行数設定用変数ID」に使用したい変数番号を設定します。
 * 2. イベントコマンドの「変数の操作」で、上記変数の値を任意の行数（例：3、5など）に設定します。
 */

(() => {
    "use strict";

    const pluginName = document.currentScript.src.match(/^.*\/([^\/]+)\.js$/)[1];
    const parameters = PluginManager.parameters(pluginName);
    
    // 変数IDを取得。@type variable を使用しているので、値は文字列で格納される
    const variableId = Number(parameters['VariableId']);

    // 元のwindowHeight関数を保存
    const _Window_Message_windowHeight = Window_Message.prototype.windowHeight;
    
    // Window_Message.prototype.windowHeightをオーバーライド
    Window_Message.prototype.windowHeight = function() {
        
        // 変数IDが有効かつ $gameVariablesが存在する場合
        if (variableId > 0 && $gameVariables) {
            // 変数から行数を取得
            const variableRows = $gameVariables.value(variableId);

            // 変数の値が1以上の場合は、その行数に基づいて高さを計算して返す
            if (variableRows >= 1) {
                return this.fittingHeight(variableRows);
            }
        }
        
        // 変数IDが無効、または変数の値が不正な場合は標準の処理を呼び出す
        return _Window_Message_windowHeight.call(this);
    };

})();